/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EntrySorter
implements Comparator<Entry>,
Serializable {
    private static final long serialVersionUID = 7606107105238612142L;
    private final boolean sortByHierarchy;
    private final List<SortKey> sortKeys;
    private final Schema schema;

    public EntrySorter() {
        this(true, null, Collections.emptyList());
    }

    public EntrySorter(boolean sortByHierarchy, SortKey ... sortKeys) {
        this(sortByHierarchy, null, Arrays.asList(sortKeys));
    }

    public EntrySorter(boolean sortByHierarchy, Schema schema, SortKey ... sortKeys) {
        this(sortByHierarchy, schema, Arrays.asList(sortKeys));
    }

    public EntrySorter(boolean sortByHierarchy, List<SortKey> sortKeys) {
        this(sortByHierarchy, null, sortKeys);
    }

    public EntrySorter(boolean sortByHierarchy, Schema schema, List<SortKey> sortKeys) {
        this.sortByHierarchy = sortByHierarchy;
        this.schema = schema;
        this.sortKeys = sortKeys == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<SortKey>(sortKeys));
    }

    public SortedSet<Entry> sort(Collection<? extends Entry> entries) {
        TreeSet<Entry> entrySet = new TreeSet<Entry>(this);
        entrySet.addAll(entries);
        return entrySet;
    }

    @Override
    public int compare(Entry e1, Entry e2) {
        DN parsedDN1 = null;
        DN parsedDN2 = null;
        if (this.sortByHierarchy) {
            try {
                parsedDN1 = e1.getParsedDN();
                parsedDN2 = e2.getParsedDN();
                if (parsedDN1.isAncestorOf(parsedDN2, false)) {
                    return -1;
                }
                if (parsedDN2.isAncestorOf(parsedDN1, false)) {
                    return 1;
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
        }
        for (SortKey k : this.sortKeys) {
            ASN1OctetString v2;
            ASN1OctetString v1;
            String attrName = k.getAttributeName();
            Attribute a1 = e1.getAttribute(attrName);
            Attribute a2 = e2.getAttribute(attrName);
            if (a1 == null || !a1.hasValue()) {
                if (a2 == null || !a2.hasValue()) continue;
                return 1;
            }
            if (a2 == null || !a2.hasValue()) {
                return -1;
            }
            MatchingRule matchingRule = MatchingRule.selectOrderingMatchingRule(attrName, k.getMatchingRuleID(), this.schema);
            if (k.reverseOrder()) {
                v1 = null;
                for (ASN1OctetString s : a1.getRawValues()) {
                    if (v1 == null) {
                        v1 = s;
                        continue;
                    }
                    try {
                        if (matchingRule.compareValues(s, v1) <= 0) continue;
                        v1 = s;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                    }
                }
                v2 = null;
                for (ASN1OctetString s : a2.getRawValues()) {
                    if (v2 == null) {
                        v2 = s;
                        continue;
                    }
                    try {
                        if (matchingRule.compareValues(s, v2) <= 0) continue;
                        v2 = s;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                    }
                }
                try {
                    int value = matchingRule.compareValues(v2, v1);
                    if (value == 0) continue;
                    return value;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    continue;
                }
            }
            v1 = null;
            for (ASN1OctetString s : a1.getRawValues()) {
                if (v1 == null) {
                    v1 = s;
                    continue;
                }
                try {
                    if (matchingRule.compareValues(s, v1) >= 0) continue;
                    v1 = s;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            v2 = null;
            for (ASN1OctetString s : a2.getRawValues()) {
                if (v2 == null) {
                    v2 = s;
                    continue;
                }
                try {
                    if (matchingRule.compareValues(s, v2) >= 0) continue;
                    v2 = s;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            try {
                int value = matchingRule.compareValues(v1, v2);
                if (value == 0) continue;
                return value;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
        }
        try {
            if (parsedDN1 == null) {
                parsedDN1 = e1.getParsedDN();
            }
            if (parsedDN2 == null) {
                parsedDN2 = e2.getParsedDN();
            }
            return parsedDN1.compareTo(parsedDN2);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            String lowerDN1 = StaticUtils.toLowerCase(e1.getDN());
            String lowerDN2 = StaticUtils.toLowerCase(e2.getDN());
            return lowerDN1.compareTo(lowerDN2);
        }
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.sortByHierarchy) {
            ++hashCode;
        }
        for (SortKey k : this.sortKeys) {
            hashCode = k.reverseOrder() ? (hashCode *= -31) : (hashCode *= 31);
            hashCode += StaticUtils.toLowerCase(k.getAttributeName()).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntrySorter)) {
            return false;
        }
        EntrySorter s = (EntrySorter)o;
        if (this.sortByHierarchy != s.sortByHierarchy) {
            return false;
        }
        return ((Object)this.sortKeys).equals(s.sortKeys);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EntrySorter(sortByHierarchy=");
        buffer.append(this.sortByHierarchy);
        buffer.append(", sortKeys={");
        Iterator<SortKey> iterator = this.sortKeys.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

