/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDIFModifyChangeRecord
extends LDIFChangeRecord {
    private static final long serialVersionUID = 6317289692291736272L;
    private final Modification[] modifications;

    public LDIFModifyChangeRecord(String dn, Modification ... modifications) {
        super(dn);
        Validator.ensureNotNull(modifications);
        Validator.ensureTrue(modifications.length > 0, "LDIFModifyChangeRecord.modifications must not be empty.");
        this.modifications = modifications;
    }

    public LDIFModifyChangeRecord(String dn, List<Modification> modifications) {
        super(dn);
        Validator.ensureNotNull(modifications);
        Validator.ensureFalse(modifications.isEmpty(), "LDIFModifyChangeRecord.modifications must not be empty.");
        this.modifications = new Modification[modifications.size()];
        modifications.toArray(this.modifications);
    }

    public LDIFModifyChangeRecord(ModifyRequest modifyRequest) {
        super(modifyRequest.getDN());
        List<Modification> mods = modifyRequest.getModifications();
        this.modifications = new Modification[mods.size()];
        Iterator<Modification> iterator = mods.iterator();
        for (int i = 0; i < this.modifications.length; ++i) {
            this.modifications[i] = iterator.next();
        }
    }

    public Modification[] getModifications() {
        return this.modifications;
    }

    public ModifyRequest toModifyRequest() {
        return new ModifyRequest(this.getDN(), this.modifications);
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY;
    }

    @Override
    public LDAPResult processChange(LDAPInterface connection) throws LDAPException {
        return connection.modify(this.toModifyRequest());
    }

    @Override
    public String[] toLDIF(int wrapColumn) {
        List<String> ldifLines = new ArrayList<String>(this.modifications.length * 4);
        ldifLines.add(LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN())));
        ldifLines.add("changetype: modify");
        block6: for (int i = 0; i < this.modifications.length; ++i) {
            String attrName = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    ldifLines.add("add: " + attrName);
                    break;
                }
                case 1: {
                    ldifLines.add("delete: " + attrName);
                    break;
                }
                case 2: {
                    ldifLines.add("replace: " + attrName);
                    break;
                }
                case 3: {
                    ldifLines.add("increment: " + attrName);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            for (ASN1OctetString value : this.modifications[i].getRawValues()) {
                ldifLines.add(LDIFWriter.encodeNameAndValue(attrName, value));
            }
            if (i >= this.modifications.length - 1) continue;
            ldifLines.add("-");
        }
        if (wrapColumn > 2) {
            ldifLines = LDIFWriter.wrapLines(wrapColumn, ldifLines);
        }
        String[] ldifArray = new String[ldifLines.size()];
        ldifLines.toArray(ldifArray);
        return ldifArray;
    }

    @Override
    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("modify"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL_BYTES);
        block6: for (int i = 0; i < this.modifications.length; ++i) {
            String attrName = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    LDIFWriter.encodeNameAndValue("add", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 1: {
                    LDIFWriter.encodeNameAndValue("delete", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 2: {
                    LDIFWriter.encodeNameAndValue("replace", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                case 3: {
                    LDIFWriter.encodeNameAndValue("increment", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            for (ASN1OctetString value : this.modifications[i].getRawValues()) {
                LDIFWriter.encodeNameAndValue(attrName, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL_BYTES);
            }
            if (i >= this.modifications.length - 1) continue;
            buffer.append('-');
            buffer.append(StaticUtils.EOL_BYTES);
        }
    }

    @Override
    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        LDIFWriter.encodeNameAndValue("dn", new ASN1OctetString(this.getDN()), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        LDIFWriter.encodeNameAndValue("changetype", new ASN1OctetString("modify"), buffer, wrapColumn);
        buffer.append(StaticUtils.EOL);
        block6: for (int i = 0; i < this.modifications.length; ++i) {
            String attrName = this.modifications[i].getAttributeName();
            switch (this.modifications[i].getModificationType().intValue()) {
                case 0: {
                    LDIFWriter.encodeNameAndValue("add", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                case 1: {
                    LDIFWriter.encodeNameAndValue("delete", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                case 2: {
                    LDIFWriter.encodeNameAndValue("replace", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                case 3: {
                    LDIFWriter.encodeNameAndValue("increment", new ASN1OctetString(attrName), buffer, wrapColumn);
                    buffer.append(StaticUtils.EOL);
                    break;
                }
                default: {
                    continue block6;
                }
            }
            for (ASN1OctetString value : this.modifications[i].getRawValues()) {
                LDIFWriter.encodeNameAndValue(attrName, value, buffer, wrapColumn);
                buffer.append(StaticUtils.EOL);
            }
            if (i >= this.modifications.length - 1) continue;
            buffer.append('-');
            buffer.append(StaticUtils.EOL);
        }
    }

    @Override
    public int hashCode() {
        int hashCode;
        try {
            hashCode = this.getParsedDN().hashCode();
        }
        catch (Exception e) {
            Debug.debugException(e);
            hashCode = StaticUtils.toLowerCase(this.getDN()).hashCode();
        }
        for (Modification m : this.modifications) {
            hashCode += m.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        LDIFModifyChangeRecord r;
        block8: {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof LDIFModifyChangeRecord)) {
                return false;
            }
            r = (LDIFModifyChangeRecord)o;
            try {
                if (!this.getParsedDN().equals(r.getParsedDN())) {
                    return false;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (StaticUtils.toLowerCase(this.getDN()).equals(StaticUtils.toLowerCase(r.getDN()))) break block8;
                return false;
            }
        }
        if (this.modifications.length != r.modifications.length) {
            return false;
        }
        for (int i = 0; i < this.modifications.length; ++i) {
            if (this.modifications[i].equals(r.modifications[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDIFModifyChangeRecord(dn='");
        buffer.append(this.getDN());
        buffer.append("', mods={");
        for (int i = 0; i < this.modifications.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.modifications[i].toString(buffer);
        }
        buffer.append("})");
    }
}

