package ch.brx.ldifviewer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import au.com.bytecode.opencsv.CSVReader;
import ch.brx.ldifviewer.TemplateReader.TemplateNameFields;


public class ContactsCSVReader extends ContactsReader  {

	NameSchema schema;
	String filename;
	ArrayList<ContactListEntry> list = null;
	HashMap<String, List<String>> dnEntry;
	String dn;
	TemplateReader template;
	boolean load;

	public ContactsCSVReader(String filename, NameSchema schema, TemplateReader template)
	{
		System.out.println("New ContactsCSVReader: " + this.toString());
		
		this.filename = filename;
		this.schema = schema;
		this.template = template;
	}

	@Override
	public void setNameSchema(NameSchema schema)
	{
		unload();
		this.schema = schema;
	}

	@Override
	ArrayList<ContactListEntry> getList() throws IOException
	{
		if(list == null)
		{
			list = new ArrayList<ContactListEntry>();
			load(true, false);
		}

		return list;
	}

	@Override
	Map<String, List<String>> getEntry(String dn) throws IOException
	{
		Map<String, List<String>> e = null;

		if( !dn.equals(this.dn) )
		{
			this.dn = dn;
			dnEntry = null;
		}

		if(dnEntry == null)
		{
			load(false, true);
		}

		if(dnEntry != null)
		{
			return dnEntry;	
		}

		return e;
	}
	
	void cancel()
	{
		load = false;
	}

	private void unload()
	{
		this.list = null;
		this.dnEntry = null;
		this.dn = null;
	}

	private void load(boolean loadList, boolean loadEntry) throws IOException
	{
		if(loadList)
		{
			list.clear();
		}
		
		load = true;

		TemplateNameFields flds = template.getNameFields();
		if(flds == null)
		{
			throw new IOException("Template does not contain field names.");
		}
		
		List<String> searchfields = template.getSearchFields();

		try {
			//determine separator

			int comaCnt = 0;
			int semicolonCnt = 0;
			int tabCnt = 0;
			char sep;

			FileInputStream  f = new FileInputStream(filename);
			int b;
			while ( (b = f.read()) >= 0) 
			{
				if(b == ',') comaCnt++;
				else if(b == ';') semicolonCnt++;
				else if(b == '\t') tabCnt++;
				else if(b == '\n' || b == '\r') break;
			} 
			f.close();

			if(comaCnt > semicolonCnt && comaCnt > tabCnt)
			{
				sep = ',';
			}
			else if(semicolonCnt > tabCnt)
			{
				sep = ';';
			}
			else
			{
				sep = '\t';
			}
			
			CSVReader csvreader = new CSVReader(
					new InputStreamReader(new FileInputStream(filename), template.getCharacterSet()),
					sep);

			String [] headerLine;
			String [] nextLine;

			headerLine = csvreader.readNext();
			
			//Fix for Windows contact csv file...
			if(headerLine[0].charAt(0) > 0x7F)
			{
				for(int ix = 0; ix < headerLine[0].length(); ix++)
				{
					if(headerLine[0].charAt(ix) <= 0x7F)
					{
						headerLine[0] = headerLine[0].substring(ix);
						break;
					}
				}
			}
			//End Fix for Windows contact csv file...

			HashMap<String, String> entry = new HashMap<String, String>();
			int recordIx = 0;

			while ( (nextLine = csvreader.readNext()) != null && load)
			{

				if(loadList) 
				{
					entry.clear();
					for(int ix = 0; ix < nextLine.length && ix < headerLine.length; ix++)
					{
						//TODO: Filter out only fields from searchfields and flds to gain performance...
						if(nextLine[ix].length() > 0)
							entry.put(headerLine[ix], nextLine[ix]);
					}

					String name = null;

					if(entry.get(flds.callName) != null)
					{
						name = entry.get(flds.callName);
					}
					else if(entry.get(flds.firstName) != null && 
							entry.get(flds.lastName) != null)
					{
						name = entry.get(flds.firstName) + " " + entry.get(flds.lastName);
					}
					else if(entry.get(flds.lastName) != null)
					{
						name = entry.get(flds.lastName);
					}
					else if(entry.get(flds.firstName) != null)
					{
						name = entry.get(flds.firstName);
					}

					if(name == null)
					{
						name = "";
					}

					switch(schema)
					{
					case USE_NAME_CALL: 
						if(entry.get(flds.callName) != null)
						{
							name = entry.get(flds.callName);
						}
						break;

					case USE_NAME_FIRST_LAST:
						if(entry.get(flds.firstName) != null && 
						entry.get(flds.lastName) != null)
						{
							name = entry.get(flds.firstName) + " " + entry.get(flds.lastName);
						}
						break;

					case USE_NAME_LAST_FIRST:

						if(entry.get(flds.firstName) != null && 
						entry.get(flds.lastName) != null)
						{
							name = entry.get(flds.lastName) + " " + entry.get(flds.firstName);
						}
						break;
					}
					
					StringBuilder info = new StringBuilder(64);
					for(String sfield: searchfields)
					{
						String val = entry.get(sfield);
						if(val != null)
						{
							boolean isNumber = true;
							for(int cix = 0; cix < val.length(); cix++)
							{
								if(Character.isLetter(val.charAt(cix)))
								{
									isNumber = false;
									break;
								}
							}

							if(isNumber)
							{
								info.append(" ");
								info.append(val.replace(" ", ""));
							}
							else
							{
								//add every word of sarr if not yet existing in name or info string
								String words[] = val.split(" ");
								for(String w:words)
								{
									if(name.indexOf(w) < 0 && info.indexOf(w) < 0)
									{
										info.append(" ");
										info.append(w);
									}
								}
							}

						}
					}

					list.add(new ContactListEntry(Integer.toString(recordIx),  name,  info.toString()  ));
				}
				else if(loadEntry)
				{
					if( dn.equals(Integer.toString(recordIx)) )
					{
						dnEntry = new HashMap<String, List<String>>();
						List<String> values;
						
						for(int ix = 0; ix < nextLine.length && ix < headerLine.length; ix++)
						{
							if(nextLine[ix].length() > 0)
							{
								values = dnEntry.get(headerLine[ix]);
								if(values == null) values = new ArrayList<String>();
								
								values.add(nextLine[ix]);
								dnEntry.put(headerLine[ix], values);
							}
						}
						
						break;
					}
				}
				recordIx++;
				
			}

			csvreader.close();
		}
		catch (IOException ioe)
		{
			System.err.println("An I/O error occurred while attempting to read " +
					"from the LDIF file:  " + ioe.getMessage());
			System.err.println("LDIF processing will be aborted.");
			throw ioe;
		}

		if(loadList)
		{
			Collections.sort(list);
		}
	}
}
