package ch.brx.ldifviewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;



public abstract class ContactsReader  {

	public enum NameSchema {
		USE_NAME_FIRST_LAST, USE_NAME_LAST_FIRST, USE_NAME_CALL 
	}

	public class ContactListEntry implements Comparable<ContactListEntry> {
		String dn;
		String name;
		String info;

		ContactListEntry(String dn, String name, String info)
		{
			this.dn = dn;
			this.name = name;
			this.info = info;
		}

		@Override
		public int compareTo(ContactListEntry another) {
			return name.compareToIgnoreCase(another.name);
		}

		@Override
		public String toString()
		{
			return name;
		}
	}

	abstract public void setNameSchema(NameSchema schema);
	abstract ArrayList<ContactListEntry> getList() throws IOException;
	abstract Map<String, List<String>> getEntry(String dn) throws IOException;
	abstract void cancel();
	
	static ContactsReader getNewContactsReader(String filename, NameSchema schema, TemplateReader template)
	{
		if(filename.endsWith(".ldif") || filename.endsWith(".ldf"))
		{
			return new ContactsLDIFReader(filename, schema, template);
		}
		else
		{
			return new ContactsCSVReader(filename, schema, template);
		}
	}
	
}
