package ch.brx.ldifviewer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

import ch.brx.ldifviewer.TemplateManager.TemplateFile;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.Spinner;
import android.widget.TextView;

public class FragmentOpenFileDialog extends DialogFragment {

	public static final String RESULT_PATH = "RESULT_PATH";
	public static final String TEMPLATE_FILE = "TEMPLATE_FILE";

	private static final String START_PATH = "START_PATH";
	private static final String FORMAT_FILTER = "FORMAT_FILTER";

	private static final String ITEM_KEY = "key";
	private static final String ITEM_IMAGE = "image";
	
	
	private String extSDRoot;


	private List<String> path = null;
	private TextView myPath;
	private ArrayList<HashMap<String, Object>> mList;

	private String parentPath;
	private String currentPath;

	private String[] formatFilter = null;

	private HashMap<String, Integer> lastPositions = new HashMap<String, Integer>();

	TemplateFile[] templateFiles;
	Spinner spinTemplate;
	ListView lvFiles;

	public static FragmentOpenFileDialog newInstance(String startPath, String[] formatFilter, String templateFile){

		FragmentOpenFileDialog dialogFragment = new FragmentOpenFileDialog();
		Bundle bundle = new Bundle();
		if(startPath != null)
		{
			bundle.putString(START_PATH, startPath);
		}
		bundle.putStringArray(FORMAT_FILTER, formatFilter);
		bundle.putString(TEMPLATE_FILE, templateFile);
		dialogFragment.setArguments(bundle);
		return dialogFragment;

	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		extSDRoot = Environment.getExternalStorageDirectory().getAbsolutePath();
		currentPath = extSDRoot;
		
		View rootView = inflater.inflate(R.layout.fragment_openfiledialog,
				container, false);
		Bundle arguments = getArguments();

		getDialog().setTitle(getString(R.string.openfile));

		templateFiles = TemplateManager.getManager(getActivity()).getTemplates();
		
		ArrayList<String> names = new ArrayList<String>();
		String setTmplName = arguments.getString(TEMPLATE_FILE);
		int spinnerPos = 0;
		int ix = 0;
		for(TemplateFile f: templateFiles)
		{
			if(f.filename.equals(setTmplName))
			{
				spinnerPos = ix;
			}

			names.add(f.name);
			ix++;
		}

		spinTemplate = (Spinner) rootView.findViewById(R.id.template_selector);
		ArrayAdapter<String> a =new ArrayAdapter<String>(getActivity(),
				android.R.layout.simple_spinner_item, names);
		a.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		spinTemplate.setAdapter(a);
		spinTemplate.setSelection(spinnerPos);


		myPath = (TextView) rootView.findViewById(R.id.path);

		formatFilter = arguments.getStringArray(FORMAT_FILTER);

		String startPath = arguments.getString(START_PATH);
		
		startPath = startPath != null ? startPath : extSDRoot;

		File f = new File(startPath);
		if(f.exists())
		{
			if(f.isFile())
			{
				startPath = f.getParent();
			}
		}
		else
		{
			startPath = extSDRoot;
		}

		Button btnDismiss = (Button)rootView.findViewById(R.id.cancel);
		btnDismiss.setOnClickListener( new View.OnClickListener() {
            public void onClick(View v) {
            	dismiss();
            }
        });

		lvFiles = (ListView) rootView.findViewById(R.id.files);
		lvFiles.setOnItemClickListener(new OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				File file = new File(path.get(position));

				//setSelectVisible(v);
				view.setVisibility(View.VISIBLE);

				if (file.isDirectory()) {
					if (file.canRead()) {
						lastPositions.put(currentPath, position);
						getDir(path.get(position));
					} else {
						new AlertDialog.Builder(getActivity())
						.setIcon(R.drawable.icon)
						.setTitle("[" + file.getName() + "] " + getText(R.string.cant_read_folder))
						.setPositiveButton("OK", new DialogInterface.OnClickListener() {

							@Override
							public void onClick(DialogInterface dialog, int which) {

							}
						}).show();
					}
				} else {
					String templateFile = templateFiles[spinTemplate.getSelectedItemPosition()].filename;

					Intent intent = new Intent();
					intent.putExtra(RESULT_PATH, file.getPath());
					intent.putExtra(TEMPLATE_FILE, templateFile);

					getTargetFragment().onActivityResult(
							getTargetRequestCode(), 
							Activity.RESULT_OK, 
							intent);
					dismiss();

				}
			}
		});
		
		getDir(startPath);

		return rootView;
	}

	private void getDir(String dirPath) {

		boolean useAutoSelection = dirPath.length() < currentPath.length();

		Integer position = lastPositions.get(parentPath);

		getDirImpl(dirPath);

		if (position != null && useAutoSelection) {
			lvFiles.setSelection(position);
		}

	}

	private void getDirImpl(final String dirPath) {

		currentPath = dirPath;

		final List<String> item = new ArrayList<String>();
		path = new ArrayList<String>();
		mList = new ArrayList<HashMap<String, Object>>();

		File f = new File(currentPath);
		File[] files = f.listFiles();
		if (files == null) {
			currentPath = extSDRoot;
			f = new File(currentPath);
			files = f.listFiles();
		}
		myPath.setText(getText(R.string.location) + ": " + currentPath);
		
		if (!currentPath.equals(extSDRoot) && !currentPath.equals("/")) 
		{
			item.add("../");
			addItem("../", R.drawable.folder);
			path.add(f.getParent());
			parentPath = f.getParent();
		}

		TreeMap<String, String> dirsMap = new TreeMap<String, String>();
		TreeMap<String, String> dirsPathMap = new TreeMap<String, String>();
		TreeMap<String, String> filesMap = new TreeMap<String, String>();
		TreeMap<String, String> filesPathMap = new TreeMap<String, String>();
		for (File file : files) {
			if (file.isDirectory()) {
				String dirName = file.getName();
				dirsMap.put(dirName, dirName);
				dirsPathMap.put(dirName, file.getPath());
			} else {
				final String fileName = file.getName();
				final String fileNameLwr = fileName.toLowerCase(Locale.US);
				// se ha um filtro de formatos, utiliza-o
				if (formatFilter != null) {
					boolean contains = false;
					for (int i = 0; i < formatFilter.length; i++) {
						final String formatLwr = formatFilter[i].toLowerCase(Locale.US);
						if (fileNameLwr.endsWith(formatLwr)) {
							contains = true;
							break;
						}
					}
					if (contains) {
						filesMap.put(fileName, fileName);
						filesPathMap.put(fileName, file.getPath());
					}
					// senao, adiciona todos os arquivos
				} else {
					filesMap.put(fileName, fileName);
					filesPathMap.put(fileName, file.getPath());
				}
			}
		}
		item.addAll(dirsMap.tailMap("").values());
		item.addAll(filesMap.tailMap("").values());
		path.addAll(dirsPathMap.tailMap("").values());
		path.addAll(filesPathMap.tailMap("").values());

		SimpleAdapter fileList = new SimpleAdapter(getActivity(), mList, R.layout.row_openfiledialog, new String[] {
			ITEM_KEY, ITEM_IMAGE }, new int[] { R.id.fdrowtext, R.id.fdrowimage });

		for (String dir : dirsMap.tailMap("").values()) {
			addItem(dir, R.drawable.folder);
		}

		for (String file : filesMap.tailMap("").values()) {
			addItem(file, R.drawable.file);
		}

		fileList.notifyDataSetChanged();

		lvFiles.setAdapter(fileList);

	}

	private void addItem(String fileName, int imageId) {
		HashMap<String, Object> item = new HashMap<String, Object>();
		item.put(ITEM_KEY, fileName);
		item.put(ITEM_IMAGE, imageId);
		mList.add(item);
	}
}
