package ch.brx.ldifviewer;

import java.util.List;
import java.util.Map;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;


public class FragmentShowContact extends Fragment 
implements OnClickListener, LoaderManager.LoaderCallbacks< Map<String, List<String>> >  {

	private View rootView = null;

	private String file = null;
	private String templFileName = null;
	private String dn = null;

	private TemplateReader tmpl = null;
	//private ContactsReader reader = null;
	private Map<String, List<String>> addressEntry = null;

	private List<TemplateParser.DisplayItem> phoneList = null;
	private List<TemplateParser.DisplayItem> mailList = null;

	private ImageButton btnPhone;
	private ImageButton btnMail;
	private ImageButton btnDetail;
	
	private ProgressBar progressBar;
	
	private ContactEntryLoader myLoader;

	public FragmentShowContact() {
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		
		rootView = inflater.inflate(R.layout.fragment_showcontact,
				container, false);
		
		
		btnPhone = (ImageButton) rootView.findViewById(R.id.saCall);
		btnPhone.setOnClickListener(this);
		btnPhone.setVisibility(View.GONE);

		btnMail = (ImageButton) rootView.findViewById(R.id.saMail);
		btnMail.setOnClickListener(this);
		btnMail.setVisibility(View.GONE);

		btnDetail = (ImageButton) rootView.findViewById(R.id.saDetails);
		btnDetail.setOnClickListener(this);
		btnDetail.setVisibility(View.GONE);
		
		progressBar = (ProgressBar) rootView.findViewById(R.id.progressBar1);
		
		LoaderManager lm = getLoaderManager();
	    final int LOADER_ID = 1;
	    myLoader = (ContactEntryLoader)lm.initLoader(LOADER_ID, null, this);

	    
	    String file = null;
		String templFileName = null;
		String dn = null;
		
	    Intent intent = getActivity().getIntent();
	    if(intent != null)
	    {
	    	file = intent.getStringExtra("file");
			templFileName = intent.getStringExtra("templFileName");
			dn = intent.getStringExtra("dn");
	    	
	    }
	    else if(savedInstanceState != null)
		{
			file = savedInstanceState.getString("file");
			templFileName = savedInstanceState.getString("templFileName");
			dn = savedInstanceState.getString("dn");
		}
	    
	    if(file != null && dn != null && templFileName != null)
		{
			showContact(file, templFileName, dn);
		}

		return rootView;
	}

	@Override 
	public void onSaveInstanceState(Bundle outState) { 
		super.onSaveInstanceState(outState); 

		if (file!=null && dn != null) { 
			outState.putString("file", this.file); 
			outState.putString("templFileName", this.templFileName); 
			outState.putString("dn", this.dn); 
		} 
	} 


	private void showPoneNumberSelector()
	{
		CharSequence[] items;
		AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
		builder.setTitle(getString(R.string.selectphone));

		if(phoneList != null)
		{
			items = new CharSequence[phoneList.size()]; 
			for(int ix = 0; ix < phoneList.size(); ix++)
			{
				items[ix] = phoneList.get(ix).display;
			}
		}
		else
		{
			items = new CharSequence[0]; 
		}

		builder.setItems(items, new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int item) {
				fireDialerIntent(phoneList.get(item).value.trim());
			}
		});
		AlertDialog alert = builder.create();
		alert.show();
	}

	private void fireDialerIntent(String number)
	{
		Intent dial = new Intent(Intent.ACTION_DIAL);
		//Intent dial = new Intent(Intent.ACTION_CALL);
		dial.setData(Uri.parse("tel:".concat(number)));
		startActivity(Intent.createChooser(dial, "Dial: "));
	}


	private static final int DIALOG_MAIL_ADDR_SELECTION = 1;
	private static final int DIALOG_DETAILS = 2;

	private void showMailSelector()
	{
		String mailDisplay[];
		String mailValue[];
		
		if(mailList != null)
		{
		mailDisplay = new String[mailList.size()];
		mailValue = new String[mailList.size()];
		for(int ix = 0; ix < mailList.size(); ix++)
		{
			mailDisplay[ix] = mailList.get(ix).display;
			mailValue[ix] = mailList.get(ix).value;
		}
		}
		else
		{
			mailDisplay = new String[0];
			mailValue = new String[0];
		}

		FragmentMailSelectorDialog newFragment = FragmentMailSelectorDialog.newInstance(mailDisplay, mailValue);
		newFragment.setTargetFragment(this, DIALOG_MAIL_ADDR_SELECTION);
		newFragment.show(getFragmentManager().beginTransaction(), "dialog");
	}

	private void fireMailIntent(String addresses)
	{
		Intent emailIntent = new Intent(Intent.ACTION_SENDTO, Uri.fromParts(
				"mailto",addresses, null));
		startActivity(Intent.createChooser(emailIntent, "Send email..."));
	}

	private void showDetails()
	{
		FragmentShowContactDetail newFragment = FragmentShowContactDetail.newInstance(addressEntry);
		newFragment.setTargetFragment(this, DIALOG_DETAILS);
		newFragment.show(getFragmentManager().beginTransaction(), "dialog");
	}

	@Override
	public void onClick(View v) {

		if(btnPhone == (ImageButton)v)
		{
			showPoneNumberSelector();
		}
		else if(btnMail == (ImageButton)v)
		{
			showMailSelector();
		}
		else if(btnDetail == (ImageButton)v)
		{
			showDetails();
		}
		else
		{

		}


	}

	@Override
	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		switch(requestCode) 
		{
		case DIALOG_MAIL_ADDR_SELECTION:
			if (resultCode == Activity.RESULT_OK) 
			{
				if(data.getStringExtra("addresses").length()>0)
				{
					fireMailIntent(data.getStringExtra("addresses"));
				}
			} else if (resultCode == Activity.RESULT_CANCELED){
				// After Cancel code.
			}

			break;
		}
	}


	

	private void adjustVisbility()
	{
		final int header[] = {R.id.header2, R.id.header3, R.id.header4, R.id.header5, R.id.header6, R.id.header7, R.id.header8};
		final int field[] = {R.id.field2, R.id.field3, R.id.field4, R.id.field5, R.id.field6, R.id.field7, R.id.field8};

		for(int ix = 0; ix < field.length; ix++)
		{
			TextView tvField = (TextView) rootView.findViewById(field[ix]);
			TextView tvHeader = (TextView) rootView.findViewById(header[ix]);
			if(tvField.getText().length() == 0 )
			{
				tvField.setVisibility(View.GONE);
				tvHeader.setVisibility(View.GONE);
			}
			else
			{
				tvField.setVisibility(View.VISIBLE);
				if(tvHeader.getText().length() == 0)
				{
					tvHeader.setVisibility(View.GONE);
				}
				else
				{
					tvHeader.setVisibility(View.VISIBLE);
				}
			}
		}

		TextView tvHeaderMain = (TextView) rootView.findViewById(R.id.header_main);
		TextView tvField1 = (TextView) rootView.findViewById(R.id.field1);
		String field1Value = tvField1.getText().toString().trim();
		String mainHeaderValue = tvHeaderMain.getText().toString().trim();

		if(field1Value.equals(mainHeaderValue) || field1Value.length() == 0)
		{
			tvField1.setVisibility(View.GONE);
		}
		else
		{
			tvField1.setVisibility(View.VISIBLE);
		}
		
		if(this.dn == null)
		{
			btnPhone.setVisibility(View.GONE);
			btnMail.setVisibility(View.GONE);
			btnDetail.setVisibility(View.GONE);
		}
		else
		{
			btnDetail.setVisibility(View.VISIBLE);
			if(phoneList != null && phoneList.size() > 0) btnPhone.setVisibility(View.VISIBLE);
			else btnPhone.setVisibility(View.GONE);
			if(mailList != null && mailList.size() > 0) btnMail.setVisibility(View.VISIBLE);
			else btnMail.setVisibility(View.GONE);
		}

	}
	
	public Loader<Map<String, List<String>>> onCreateLoader(int id, Bundle args)
	{ 
		return new ContactEntryLoader(getActivity());
	}

	public void onLoadFinished(Loader<Map<String, List<String>>> loader, Map<String, List<String>> data) 
	{  
		if(data != null)
		{
			displayContact(data);
		}
		else
		{
			clearContact();
		}
	}

	public void onLoaderReset(Loader< Map<String, List<String>> > loader) 
	{ 
		clearContact();
	}

	public void showContact(String file, String templateFile, String dn)
	{
		if(tmpl == null || this.templFileName == null || !this.templFileName.equals(templateFile))
		{
			tmpl = new TemplateReader(getActivity(), templateFile);
			this.templFileName = templateFile;
		}

		clearContact();
		progressBar.setVisibility(View.VISIBLE);
		
		this.file = file;
		this.templFileName = templateFile;
		this.dn = dn;
		
		myLoader.getEntry(file, dn, ContactsReader.NameSchema.USE_NAME_CALL, tmpl);

	}
	
	public void displayContact(Map<String, List<String>> entry)
	{
		addressEntry = entry;
		
		progressBar.setVisibility(View.GONE);

		if(addressEntry != null && tmpl != null)
		{
			TemplateParser tmplPrsr = new TemplateParser(getActivity(), tmpl, addressEntry);
			phoneList = tmplPrsr.getPhoneList();
			mailList = tmplPrsr.getMailList();

			TextView tv;
			tv = (TextView) rootView.findViewById(R.id.header_main);
			tv.setText(tmplPrsr.getField(0));

			tv = (TextView) rootView.findViewById(R.id.field1);
			tv.setText(tmplPrsr.getField(1));

			tv = (TextView) rootView.findViewById(R.id.field2);
			tv.setText(tmplPrsr.getField(2));

			tv = (TextView) rootView.findViewById(R.id.field3);
			tv.setText(tmplPrsr.getField(3));

			tv = (TextView) rootView.findViewById(R.id.field4);
			tv.setText(tmplPrsr.getField(4));

			tv = (TextView) rootView.findViewById(R.id.field5);
			tv.setText(tmplPrsr.getField(5));

			tv = (TextView) rootView.findViewById(R.id.field6);
			tv.setText(tmplPrsr.getField(6));

			tv = (TextView) rootView.findViewById(R.id.field7);
			tv.setText(tmplPrsr.getField(7));

			tv = (TextView) rootView.findViewById(R.id.field8);
			tv.setText(tmplPrsr.getField(8));



			tv = (TextView) rootView.findViewById(R.id.header2);
			tv.setText(tmplPrsr.getHeader(2));

			tv = (TextView) rootView.findViewById(R.id.header3);
			tv.setText(tmplPrsr.getHeader(3));

			tv = (TextView) rootView.findViewById(R.id.header4);
			tv.setText(tmplPrsr.getHeader(4));

			tv = (TextView) rootView.findViewById(R.id.header5);
			tv.setText(tmplPrsr.getHeader(5));

			tv = (TextView) rootView.findViewById(R.id.header6);
			tv.setText(tmplPrsr.getHeader(6));

			tv = (TextView) rootView.findViewById(R.id.header7);
			tv.setText(tmplPrsr.getHeader(7));

			tv = (TextView) rootView.findViewById(R.id.header8);
			tv.setText(tmplPrsr.getHeader(8));

			/**<!--
			    field0==========
			    field1===============

			    header2       header4
			    field2        field4
			    .
			                  header5
			    header3       field5
			    field3

			    header6.......header7
			    field6        fieald7

			    header8==============
			    field8===============
			    -->*/

			if(tmpl.isHeaderDynamic(4))
			{
				TextView tvField2 = (TextView) rootView.findViewById(R.id.field2);
				TextView tvHeader4 = (TextView) rootView.findViewById(R.id.header4);
				if(tvField2.getText().length() > 0)
				{
					tvHeader4.setText(" ");
				}
			}

			if(tmpl.isHeaderDynamic(7))
			{
				TextView tvField6 = (TextView) rootView.findViewById(R.id.field6);
				TextView tvHeader7 = (TextView) rootView.findViewById(R.id.header7);
				if(tvField6.getText().length() > 0)
				{
					tvHeader7.setText(" ");
				}
			}


			adjustVisbility();

			float colWidthPercent = tmpl.getLeftColumnWidth();
			LinearLayout linearLayout = (LinearLayout) rootView.findViewById(R.id.col1a);
			LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)linearLayout.getLayoutParams();
			layoutParams.weight = colWidthPercent;
			linearLayout.setLayoutParams(layoutParams);

			linearLayout = (LinearLayout) rootView.findViewById(R.id.col1b);
			layoutParams = (LinearLayout.LayoutParams)linearLayout.getLayoutParams();
			layoutParams.weight = colWidthPercent;
			linearLayout.setLayoutParams(layoutParams);

			linearLayout = (LinearLayout) rootView.findViewById(R.id.col2a);
			layoutParams = (LinearLayout.LayoutParams)linearLayout.getLayoutParams();
			layoutParams.weight = 100-colWidthPercent;
			linearLayout.setLayoutParams(layoutParams);

			linearLayout = (LinearLayout) rootView.findViewById(R.id.col2b);
			layoutParams = (LinearLayout.LayoutParams)linearLayout.getLayoutParams();
			layoutParams.weight = 100-colWidthPercent;
			linearLayout.setLayoutParams(layoutParams);


		}
		else
		{
			System.err.println("Entry not found. DN:"+dn);
			clearContact();
		}
	}


	public void clearContact()
	{
		this.file = null;
		this.dn = null;
		this.templFileName = null;

		phoneList = null;
		mailList = null;
		
		progressBar.setVisibility(View.GONE);


		((TextView) rootView.findViewById(R.id.header_main)).setText("");
		((TextView) rootView.findViewById(R.id.field1)).setText("");
		((TextView) rootView.findViewById(R.id.field2)).setText("");
		((TextView) rootView.findViewById(R.id.field3)).setText("");
		((TextView) rootView.findViewById(R.id.field4)).setText("");
		((TextView) rootView.findViewById(R.id.field5)).setText("");
		((TextView) rootView.findViewById(R.id.field6)).setText("");
		((TextView) rootView.findViewById(R.id.field7)).setText("");
		((TextView) rootView.findViewById(R.id.field8)).setText("");

		((TextView) rootView.findViewById(R.id.header2)).setText("");
		((TextView) rootView.findViewById(R.id.header3)).setText("");
		((TextView) rootView.findViewById(R.id.header4)).setText("");
		((TextView) rootView.findViewById(R.id.header5)).setText("");
		((TextView) rootView.findViewById(R.id.header6)).setText("");
		((TextView) rootView.findViewById(R.id.header7)).setText("");
		((TextView) rootView.findViewById(R.id.header8)).setText("");

		adjustVisbility();
	}
}