package ch.brx.ldifviewer;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import android.content.Context;

public class TemplateParser {


	class DisplayItem {
		String display;
		String value;
	}

	private Context ctx;
	private TemplateReader tmpl;
	private Map<String, List<String>> addressEntry;
	private ArrayList<DisplayItem> phoneList;
	private ArrayList<DisplayItem> mailList;

	TemplateParser(Context ctx, TemplateReader tmpl, Map<String, List<String>> addressEntry)
	{
		this.ctx = ctx;
		this.tmpl = tmpl;
		this.addressEntry = parseExpressions(addressEntry, tmpl.getExpressions());

		phoneList = new ArrayList<DisplayItem>();
		mailList = new ArrayList<DisplayItem>();
	}

	String getField(int id)
	{
		if(addressEntry != null)
		{
			return parseTemplate(tmpl.getFieldTemplate(id), addressEntry);
		}
		else
		{
			return "";
		}
	}

	String getHeader(int id)
	{
		return tmpl.getHeaderValue(id);
	}

	List<DisplayItem> getPhoneList()
	{
		return phoneList;
	}

	List<DisplayItem> getMailList()
	{
		return mailList;
	}

	private class NumberFormats 
	{
		int length;
		String beginning;
		String format;

		NumberFormats(String format)
		{
			StringBuilder t = new StringBuilder(format.length());

			this.length = 0;
			this.format = format;
			for(int ix = 0; ix < format.length(); ix++)
			{
				char c = format.charAt(ix);
				if(c == '+' || Character.isDigit(c))
				{
					t.append(c);
					this.length++;
				}
				else if(c == '%')
				{
					this.length++;
				}
			}
			this.beginning = t.toString();
		}
	}


	private String format_phone(String number)
	{
		String compactedNumber = number.replace(" ", "");

		ArrayList<NumberFormats> farray = new ArrayList<NumberFormats>();
		for(String n:tmpl.getPhoneFormats())
		{
			NumberFormats entry = new NumberFormats(n);
			farray.add(entry);

			if(n.charAt(0) == '+')
			{
				entry = new NumberFormats("00".concat(n.substring(1)));
				farray.add(entry);
			}
		}

		//find longest match
		NumberFormats fmatch = null;
		for(NumberFormats f: farray)
		{
			if(f.length == compactedNumber.length() && compactedNumber.startsWith(f.beginning))
			{
				if(fmatch == null)
				{
					fmatch = f;
				}
				else if(fmatch.beginning.length() < f.beginning.length())
				{
					fmatch = f;
				}

			}
		}

		if(fmatch != null)
		{
			StringBuilder formatedNr = new StringBuilder(fmatch.length);
			for(int ixFormat = 0, ixNumber = 0; ixFormat < fmatch.format.length();ixFormat++)
			{
				if(Character.isDigit(fmatch.format.charAt(ixFormat)) ||
						fmatch.format.charAt(ixFormat) == '%' ||
						fmatch.format.charAt(ixFormat) == '+')
				{
					formatedNr.append(compactedNumber.charAt(ixNumber));
					ixNumber++;
				}
				else
				{
					formatedNr.append(fmatch.format.charAt(ixFormat));
				}
			}
			return formatedNr.toString();
		}
		else
		{
			return number;
		}
	}

	String format_empty(String field_value)
	{

		if(field_value.equalsIgnoreCase("unspecified"))
		{
			field_value = null;
		}
		else
		{
			boolean only_zero = true;
			for(int cix = 0; cix < field_value.length(); cix++)
			{
				if(field_value.charAt(cix) != '0' && field_value.charAt(cix) != '.')
					only_zero = false;
			}

			if(only_zero) field_value = null;
		}

		return field_value;
	}

	private static int countOccurrences(String haystack, char needle)
	{
		int count = 0;
		for (int i=0; i < haystack.length(); i++)
		{
			if (haystack.charAt(i) == needle)
			{
				count++;
			}
		}
		return count;
	}

	private String[] getFieldList(String fields)
	{
		int startIx, endIx, ix;	
		String [] fieldArray = new String[countOccurrences(fields,'{')];
		int arrayIx = 0;

		startIx = fields.indexOf('{');
		while(startIx >= 0 && startIx < fields.length())
		{
			endIx = fields.indexOf('}', startIx);
			if(endIx < 0)
			{
				break;
			}
			ix = fields.indexOf(':', startIx);
			if(ix >= 0 && ix < endIx) {
				endIx = ix;
			}
			ix = fields.indexOf('/', startIx);
			if(ix >= 0 && ix < endIx) {
				endIx = ix;
			}
			fieldArray[arrayIx] = fields.substring(startIx+1, endIx);
			arrayIx++;
			startIx = endIx + 1;

			if(startIx >= fields.length())
			{
				break;
			}
			startIx = fields.indexOf('{', startIx);
		}

		return fieldArray;
	}

	private Map<String, List<String>>  parseExpressions(Map<String, List<String>> entries, List<TemplateReader.TemplateExpression> exprs)
	{

		Map<String, List<String>> entriesCpy = new HashMap<String, List<String>>();

		Iterator<Entry<String, List<String>>> it = entries.entrySet().iterator();
		while (it.hasNext()) {
			Entry<String, List<String>> pairs = (Entry<String, List<String>>)it.next();
			entriesCpy.put(pairs.getKey(), new ArrayList<String>(pairs.getValue()));
		}

		for(TemplateReader.TemplateExpression e: exprs )
		{
			ArrayList<String> arr = new ArrayList<String>();
			if(e.type.equals("date"))
			{
				String date_string = "";
				String[] flds = getFieldList(e.fields);
				if(flds.length == 3)
				{
					String day = null, month = null, year = null;
					if(entriesCpy.get(flds[0]) != null)
					{
						day = entriesCpy.get(flds[0]).get(0);
					}
					if(entriesCpy.get(flds[1]) != null)
					{
						month = entriesCpy.get(flds[1]).get(0);
					}
					if(entriesCpy.get(flds[2]) != null)
					{
						year = entriesCpy.get(flds[2]).get(0);
					}

					if(month != null && Character.isLetter(month.charAt(0)))
					{
						if(day != null)
						{
							date_string = day.concat(". ");
						}
						date_string = date_string.concat(month);
						if(year != null)
						{
							if(date_string.length() > 0)
							{
								date_string = date_string.concat(" ");
							}
							date_string = date_string.concat(year);
						}
					}
					else if(day == null && month == null && year != null)
					{
						date_string = year;
					}
					else if(day == null && month != null && year != null)
					{
						date_string = month.concat("/").concat(year);
					}
					else if(day != null && month != null && year != null)
					{
						Calendar cal = new GregorianCalendar(Integer.parseInt(year), 
								Integer.parseInt(month), 
								Integer.parseInt(day));
						java.text.DateFormat df = android.text.format.DateFormat.getDateFormat(ctx); 
						date_string = df.format(cal.getTime());
					}
					if(date_string.length() > 0)
					{
						arr.add(date_string);
					}
				}
			}

			if(e.name != null && !arr.isEmpty())
			{
				entriesCpy.put(e.name, arr);
			}
		}
		return entriesCpy;
	}

	private boolean addEmptyLine;

	private String parseTemplateField(String tmpl, int startIx, int endIx, char seperator, Map<String, List<String>> entry)
	{

		StringBuilder fullfield = new StringBuilder(32);
		String modifier = "";
		String txtBefore = "";
		String txtAfter = "";


		int fieldsep2 = tmpl.indexOf('/', startIx + 1);
		if(fieldsep2<=0 || fieldsep2 > endIx) {
			fieldsep2 = endIx;
		}

		int fieldsep1 = tmpl.indexOf(':', startIx + 1);
		if(fieldsep1<=0 || fieldsep1 > fieldsep2) {
			fieldsep1 = fieldsep2;
		}

		int fieldsep3 = tmpl.indexOf('/', fieldsep2 + 1);
		if(fieldsep3<=0 || fieldsep3 > endIx) {
			fieldsep3 = endIx;
		}

		String fieldName = tmpl.substring(startIx + 1, fieldsep1);

		if(fieldsep1+1 < fieldsep2)
		{
			modifier = tmpl.substring(fieldsep1+1, fieldsep2);
		}

		if(fieldsep2+1 < fieldsep3)
		{
			txtBefore = tmpl.substring(fieldsep2+1, fieldsep3);
		}

		if(fieldsep3+1 < endIx)
		{
			txtAfter = tmpl.substring(fieldsep3+1, endIx);
		}

		if(fieldName.equals("-"))
		{
			addEmptyLine = true;
		}
		else
		{
			List<String> field_values =  entry.get(fieldName);

			if(field_values != null)
			{
				boolean first = true;;
				for(String field_value: field_values)
				{
					if(modifier != null)
					{
						if(modifier.indexOf('p') >= 0)
						{
							field_value = format_phone(field_value);
						}
						else if(modifier.indexOf('D') >= 0)
						{
							field_value = format_empty(field_value);
						}
					}

					if(field_value != null)
					{
						if(!first)
						{
							fullfield.append(seperator);
						}

						if(txtBefore != null) fullfield.append(txtBefore);
						fullfield.append(field_value);
						if(txtAfter != null) fullfield.append(txtAfter);

						if(modifier != null)
						{
							DisplayItem item = new DisplayItem();

							item.display = field_value;
							if(txtBefore != null) item.display = txtBefore.concat(item.display);
							if(txtAfter != null) item.display = item.display.concat(txtAfter);
							item.value = field_value;

							if(modifier.indexOf('p') >= 0)
							{
								phoneList.add( item );
							}
							else if(modifier.indexOf('e') >= 0)
							{
								mailList.add( item );
							}
						}

						first = false;
					}
				}
			}
		}

		return fullfield.toString();
	}

	private String parseTemplateLine(String tmpl, int startIx, int endIx, Map<String, List<String>> entry)
	{
		StringBuilder line = new StringBuilder(32);

		while(startIx < endIx)
		{
			char seperator;
			int fieldOpenIx = tmpl.indexOf('{', startIx);

			if(fieldOpenIx < 0 || fieldOpenIx > endIx)
			{
				line.append(tmpl.substring(startIx, endIx));
				break;
			}
			else if(fieldOpenIx>0)
			{
				line.append(tmpl.substring(startIx, fieldOpenIx));
			}

			int fieldCloseIx = tmpl.indexOf('}', fieldOpenIx + 1);
			if(fieldCloseIx<=0) {
				System.err.println("Template field not closed.");
				break;
			}

			if(endIx + 1 < tmpl.length())
			{
				seperator = tmpl.charAt(endIx + 1);
			}
			else
			{
				seperator = '\n';
			}

			line.append(parseTemplateField(tmpl, fieldOpenIx, fieldCloseIx, seperator, entry));
			startIx = fieldCloseIx+1;
		}

		return line.toString();
	}

	private String parseTemplate(String tmpl, Map<String, List<String>> entry)
	{
		StringBuilder output = new StringBuilder(256);
		int inputIx = 0;
		int lineIx = 0;

		addEmptyLine = false;
		while(inputIx < tmpl.length())
		{
			int eol_ix = tmpl.indexOf('\n', inputIx);
			if(eol_ix < 0)
			{
				eol_ix = tmpl.length();
			}

			String line = parseTemplateLine(tmpl, inputIx, eol_ix, entry);

			if(line.length() > 0)
			{
				if(addEmptyLine)
				{
					output.append('\n');
					addEmptyLine = false;
				}

				if(lineIx > 0)
				{
					output.append('\n');
				}
				output.append(line);
				lineIx++;
			}
			
			inputIx = eol_ix + 1;
		}

		return output.toString();
	}
}
